#ifndef _PENDINGTRANS_CPP
#define _PENDINGTRANS_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.h>

#include "../Resources/Resource.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../../SharedSource/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/Replication.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/PendingTrans.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND PendingTransDlg_hWnd = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK PendingTransDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

	static HWND TablesList_hWnd = NULL;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG)
    {
		PendingTransDlg_hWnd = xHandle;

        char sCaption[1024];
		sprintf(sCaption, "%s :: %s", gsTitleCaption, "Pending Transactions");
		SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)sCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_TRAYICON)) );

		LV_COLUMN MyLVColumb;
		memset(&MyLVColumb, 0, sizeof(MyLVColumb));

		TablesList_hWnd = GetDlgItem(xHandle, IDC_TALBES);

        int iLVStyle = LVS_EX_GRIDLINES;
        SendMessage(TablesList_hWnd, (UINT)LVM_SETEXTENDEDLISTVIEWSTYLE, (WPARAM)0, (LPARAM)iLVStyle);

		// Create Listview columbs
        MyLVColumb.cx        = 150;
        MyLVColumb.pszText   = "Transactions";
        MyLVColumb.iSubItem  = 0;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(TablesList_hWnd, 0, &MyLVColumb);

        MyLVColumb.cx        = 150;
        MyLVColumb.pszText   = "Database";
        MyLVColumb.iSubItem  = 1;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(TablesList_hWnd, 1, &MyLVColumb);

        MyLVColumb.cx        = 200;
        MyLVColumb.pszText   = "Table";
        MyLVColumb.iSubItem  = 2;
        MyLVColumb.mask      = LVCF_WIDTH | LVCF_TEXT | LVCF_SUBITEM;
        MyLVColumb.fmt       = LVCFMT_LEFT;
        ListView_InsertColumn(TablesList_hWnd, 2, &MyLVColumb);

		PopPendingTransGrid(TablesList_hWnd);

		CenterWindow(xHandle);

        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {
        if(wParam == ID_CLOSE)
        {
			EndDialog(xHandle,0);
			DestroyWindow(xHandle);
			return TRUE;
        }
		
		return FALSE;
    }

	//--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE) 
    {
        EndDialog(xHandle,0);
        DestroyWindow(xHandle);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool PopPendingTransGrid(HWND TablesList_hWnd)
{
	int iItem = 0;
	
	char sTemp[1024];
	int iTempSz = 0;

	CSQL cSQL;
	CRecordSet rsTemp;
	
	LV_ITEM MyLVItem;
	memset(&MyLVItem, 0, sizeof(MyLVItem));

	char sSQL[1024];
	sprintf(sSQL, "SELECT Count(TransDB), TransDB, TransTable"
		" FROM [%s].[%s].[SQLExch_Trans]"
		" GROUP BY  TransDB, TransTable"
		" ORDER BY Count(TransDB) DESC, TransDB, TransTable",
		gsReplicationDB, gsDefaultDBO);

	if(!cSQL.Connect(gsSQLDriver, gsSQLServer, gsSQLUserID, gsSQLPassword, gsSQLDatabase))
	{
		MsgBox("Failed to connect to the SQL server.");
		return false;
	}

	cSQL.Execute(sSQL, &rsTemp);

	while(rsTemp.Fetch())
	{
		rsTemp.sColumnEx(1, sTemp, sizeof(sTemp), &iTempSz);
		MyLVItem.pszText = sTemp;
        MyLVItem.mask = LVIF_TEXT;
        MyLVItem.iSubItem = 0;
		MyLVItem.iItem = iItem;
        ListView_InsertItem(TablesList_hWnd, &MyLVItem);

		rsTemp.sColumnEx(2, sTemp, sizeof(sTemp), &iTempSz);
        MyLVItem.pszText = sTemp;
        MyLVItem.mask = LVIF_TEXT;
        MyLVItem.iSubItem = 1;
		MyLVItem.iItem = iItem;
        ListView_SetItem(TablesList_hWnd, &MyLVItem);

		rsTemp.sColumnEx(3, sTemp, sizeof(sTemp), &iTempSz);
        MyLVItem.pszText = sTemp;
        MyLVItem.mask = LVIF_TEXT;
        MyLVItem.iSubItem = 2;
		MyLVItem.iItem = iItem;
        ListView_SetItem(TablesList_hWnd, &MyLVItem);
		iItem++;
	}

	cSQL.Disconnect();

	return true;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

